*** 2004 
import delimited "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\amb_naic\LHSHDR_2004.TXT", clear 
rename v1 amb_number
rename v2 amb_name 
rename v3 naic 
gen year = . 
replace year = 2004 
save "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\amb_naic\amb_to_naic.dta", replace 

*** now loop through the rest of the years

forval y = 2005/2015{
import delimited "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\amb_naic\LHSHDR_`y'.TXT", clear 
rename v1 amb_number
rename v2 amb_name 
rename v3 naic 
gen year = . 
replace year = `y' 

append using "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\amb_naic\amb_to_naic.dta", force
sleep 2000
save "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\amb_naic\amb_to_naic.dta", replace
}  


*** list of insurers
use "/Users/Natasha Sarin/Dropbox/Z__Natamir/Natasha_Research/Insurance/Data/Merge_Diversification_Ownership/Data/merge.dta", clear
br if year == 2015 & quarter == 1 & _merge == 3 & assets != . 
keep if _merge == 3

*** has 734 w/ non-missing assets Q1 2015, about right 
keep naic 
capture drop output_indicator
by naic, sort: gen output_indicator = _n 
keep if output_indicator == 1 
save "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\amb_naic\naics_used.dta", replace
*** 1602 unique NAICs operate at some point in our sample 

*** make sure liabilities has all the NAICs that operate at some point

*** make sure AMB-NAIC has all the NAICS that operate at some point 

use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\amb_naic\amb_to_naic.dta", clear
destring naic, replace
drop if naic == . 
*** obviously don't need these bc will have nothing to match on w/ liabiliteis
by amb_number naic, sort: gen output_amb = _n 
keep if output_amb == 1
*** now we want to know if there are repeat amb numbers in the above
by amb_number, sort: gen test = _n 
br if test != 1
*** now we want to know if repeat naics in the above
by naic, sort: gen test2 = _n 
br if test2 != 1 
drop if test2 != 1
*** although in most cases amb numbers are constant over time, we found 7 where they weren't. we will manually adjust these at the end when all merged by carrying the AMB number until it changes. this is to get more merges below because otherwise AMB numbers missing even when exist later for reason unclear 
save "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\amb_naic\amb_to_naicv2.dta", replace


*** on the liabilities side, we have all the data, now we just want to get data for firms in our sample
use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\historical_ratings\historical_liabilities_full.dta", clear
merge m:1 naic using "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\amb_naic\naics_used.dta"
*** naics used are all of th enaics in PE sample
keep if _merge == 3
keep if quarter == 4
*** this gives us annual data to match with above 
*** amb number only appears in data when there are non-zero liabilities 
*** we will only have reinsurance contracts when non-zero liabilities 
*** so feels like okay to drop when zero liabilities 
keep if liabilities != . 
capture drop _merge 
*** this cuts out liabilities for all the P&C and Health cos we don't need, as well as where liabilities missing
save "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\historical_ratings\historical_liabilities_fullv2.dta", replace

*** let's merge naic numbers onto this liabilities data 
merge m:1 naic using "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\amb_naic\amb_to_naicv2.dta"

save "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\historical_ratings\historical_liabilities_fullv2_withamb.dta", replace

*** why so many unmatched. first let's see NAICs that don't have AMB
use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\historical_ratings\historical_liabilities_fullv2_withamb.dta", clear
keep if _merge == 1
by naic, sort: gen help = _n 
br if help == 1
*** about 384 NAICs that appear not to have AMB coverage over our sample period, don't see these naics in any of the AMB files matching NAIC/AMB number that I have   
**** at some point may be worth trying to figure out whether these are on AMB radar in some way or if just NAIC is missing

*** why so many unmatched. then AMB that don't have NAIC 
use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\historical_ratings\historical_liabilities_fullv2_withamb.dta", clear
keep if _merge == 2
by naic, sort: gen help = _n 
br if help == 1
*** about 116 NAICs without liabilities information, these are mostly FRATS (some fraternal insurance filings) or health filers

*** now let's keep only matches
use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\historical_ratings\historical_liabilities_fullv2_withamb.dta", clear
keep if _merge == 3
by naic, sort: gen help = _n 
br if help == 1
*** 792 unique matches btwn SNL and AMB 
*** manual fixes of AMB codes that we know are messed up, see naic_amb_duplicate_problems.txt
replace amb_number = 6184 if naic == 61573 & year <= 2009 
replace amb_number = 61755 if naic == 62200 & year >= 2015 
replace amb_number = 60720 if naic == 64394 & year >= 2014 
replace amb_number = 6996 if naic == 68446 & year <= 2007 
replace amb_number = 60720 if naic == 6023 & year <= 2011 
replace amb_number = 7167 if naic == 91693 & year <= 2007 

capture drop _merge

save "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Insurance\Data\Reinsurance\historical_ratings\historical_liabilities_fullv3_withamb.dta", replace




